<?php
  

function wf_google_api_scripts() {


  $options_woofood = get_option('woofood_options');

$woofood_google_api_key = isset($options_woofood['woofood_google_api_key']) ? $options_woofood['woofood_google_api_key'] : null ;

  global $wp_scripts; $gmapsenqueued = false;
  foreach ($wp_scripts->registered as $key => $script) {
    if (preg_match('#maps\.google(?:\w+)?\.com/maps/api/js#', $script->src)) {
      $gmapsenqueued = true;
    }
  }

  if (!empty($woofood_google_api_key) && !$gmapsenqueued) {
    wp_enqueue_script('google-autocomplete', 'https://maps.googleapis.com/maps/api/js?v=3&libraries=places&key='.$woofood_google_api_key.'&language='.substr(get_bloginfo ( 'language' ), null, 2));

  }

 

    wp_enqueue_script('rp-autocomplete', WOOFOOD_PLUGIN_URL. 'js/autocomplete.js', array('jquery', 'google-autocomplete'), WOOFOOD_PLUGIN_VERSION);

}





add_action('wp_enqueue_scripts', 'wf_google_api_scripts');





//check distance on checkout//

$options_woofood = get_option('woofood_options');
$woofood_google_distance_matrix_api_key = isset($options_woofood['woofood_google_distance_matrix_api_key']) ? $options_woofood['woofood_google_distance_matrix_api_key'] : null ;
$woofood_max_delivery_distance = isset($options_woofood['woofood_max_delivery_distance']) ? $options_woofood['woofood_max_delivery_distance'] : null ;
$woofood_store_address = isset($options_woofood['woofood_store_address']) ? $options_woofood['woofood_store_address'] : null ;
$woofood_distance_type = isset($options_woofood['woofood_distance_type']) ? $options_woofood['woofood_distance_type'] : "default" ;
$woofood_polygon_area = isset($options_woofood['woofood_polygon_area']) ? $options_woofood['woofood_polygon_area'] : null;
$woofood_postalcodes = isset($options_woofood['woofood_postalcodes']) ? $options_woofood['woofood_postalcodes'] : null;

if(!empty($woofood_google_distance_matrix_api_key) && !empty($woofood_max_delivery_distance )  && !empty($woofood_store_address ) && ($woofood_distance_type  ==="default") )
{

  add_action( 'woocommerce_checkout_process', 'wf_check_distance' );

  function wf_check_distance() {
    $woofood_core_is_enabled = woofood_core_is_enabled();
    if($woofood_core_is_enabled )
    {


    if(isset($_POST['woofood_order_type']) && $_POST['woofood_order_type'] =="pickup" )
    {

    }
    else
    {
      $options_woofood = get_option('woofood_options');




      $woofood_google_distance_matrix_api_key = $options_woofood['woofood_google_distance_matrix_api_key'];
      $woofood_max_delivery_distance = $options_woofood['woofood_max_delivery_distance'];
      $woofood_store_address = $options_woofood['woofood_store_address'];

      $woofood_current_address = isset($_POST['ship_to_different_address']) ? $_POST['shipping_address_1'] : $_POST['billing_address_1'];
      $woofood_current_postcode = isset($_POST['ship_to_different_address']) ? $_POST['shipping_postcode'] : $_POST['billing_postcode'];
      $woofood_current_city = isset($_POST['ship_to_different_address']) ? $_POST['shipping_city'] : $_POST['billing_city'];



      $woofood_total_address = $woofood_current_address.",".$woofood_current_city.",".$woofood_current_postcode;

      $details = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".urlencode($woofood_store_address)."&destinations=".urlencode($woofood_total_address)."&mode=driving&sensor=false&key=".$woofood_google_distance_matrix_api_key;
      $details = htmlspecialchars_decode($details);
      $details = str_replace("&amp;", "&", $details );
      $json = woofood_get_contents($details);


 /*wc_add_notice( 
    sprintf(  $json , 
      $woofood_delivery_hour_start, 
      $woofood_delivery_hour_end
      ), 'error' 
    );*/

    $details = json_decode($json, TRUE);


    if(!empty($details["error_message"]))
    {
     wc_add_notice( 
      sprintf( "Google API Error:".$details["error_message"].".Please Correct the configuration for Distance Matrix API Key on your Google Console Account", 
        $woofood_delivery_hour_start, 
        $woofood_delivery_hour_end
      ), 'error' 
    );
   }



   elseif (($details['rows'][0]['elements'][0]['status'] =="OK"))
   {
      $distance_km  = $details['rows'][0]['elements'][0]['distance']['value'] /1000;
      $customer_full_address = $woofood_total_address;

      $store_address = $woofood_store_address;

      do_action("wpslash_distance_check_checkout_completed", $distance_km, $store_address, $customer_full_address);
      
    if(($details['rows'][0]['elements'][0]['distance']['value'] <= $woofood_max_delivery_distance *1000))
    {


    }
    else
    {
          wc_add_notice( 
      sprintf( esc_html__('Delivery Service is Not Available in your Area..', 'woofood-plugin') , 
        $woofood_delivery_hour_start, 
        $woofood_delivery_hour_end
      ), 'error' 
    );

    }



   }


   else{

//we cannot deliver// show message//
    wc_add_notice( 
      sprintf( esc_html__('Delivery Service is Not Available in your Area..', 'woofood-plugin') , 
        $woofood_delivery_hour_start, 
        $woofood_delivery_hour_end
      ), 'error' 
    );


}//end else




} //end else if order type is delivery


  }

}//end function
//check distance on checkout//


}








if(!empty($woofood_google_distance_matrix_api_key)  && !empty($woofood_polygon_area)  && !empty($woofood_store_address ) && ($woofood_distance_type  ==="polygon"))
{

  add_action( 'woocommerce_checkout_process', 'wf_check_polygon' );

  function wf_check_polygon() {
     $woofood_core_is_enabled = woofood_core_is_enabled();
    if($woofood_core_is_enabled )
    {
    if(isset($_POST['woofood_order_type']) && $_POST['woofood_order_type'] =="pickup" )
    {

    }
    else
    {
      $options_woofood = get_option('woofood_options');





      $woofood_google_distance_matrix_api_key = $options_woofood['woofood_google_distance_matrix_api_key'];
      $woofood_max_delivery_distance = $options_woofood['woofood_max_delivery_distance'];
      $woofood_store_address = $options_woofood['woofood_store_address'];




      $woofood_current_address = isset($_POST['ship_to_different_address']) ? $_POST['shipping_address_1'] : $_POST['billing_address_1'];
      $woofood_current_postcode = isset($_POST['ship_to_different_address']) ? $_POST['shipping_postcode'] : $_POST['billing_postcode'];
      $woofood_current_city = isset($_POST['ship_to_different_address']) ? $_POST['shipping_city'] : $_POST['billing_city'];

      $woofood_total_address = $woofood_current_address.",".$woofood_current_city.",".$woofood_current_postcode;

      $details = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($woofood_total_address)."&key=".$woofood_google_distance_matrix_api_key."";
      $details = htmlspecialchars_decode($details);
      $details = str_replace("&amp;", "&", $details );
      $json = woofood_get_contents($details);
      $woofood_polygon_area = $options_woofood['woofood_polygon_area'];


      
             /*    wc_add_notice( 
                json_encode($woofood_polygon_area), 'error' 
                );
            */
                

                $details = json_decode($json, TRUE);


                if(!empty($details["error_message"]))
                {
                 wc_add_notice( 
                  sprintf( "Google API Error:".$details["error_message"].".Please Correct the configuration for  API Key on your Google Console Account", 
                    $woofood_delivery_hour_start, 
                    $woofood_delivery_hour_end
                  ), 'error' 
                );
               }



               elseif ( !empty($details['results'][0]['geometry']['location']["lat"] ) && !empty($details['results'][0]['geometry']['location']["lng"] ))
               {
                $polygon_area_points  = json_decode($woofood_polygon_area , true);
                $points_x =array();
                $points_y =array();

                foreach($polygon_area_points as $current_point)
                {
                 $points_x[] = $current_point["lng"];
                 $points_y[] = $current_point["lat"];

               }

              //we got customers lat/lng//
               $latitude_y =  $details['results'][0]['geometry']['location']["lat"];

               $longitude_x =  $details['results'][0]['geometry']['location']["lng"];
             $points_polygon = count($points_x);  // number vertices - zero-based array

             


             if (!woofood_check_if_is_in_polygon($points_polygon, $points_x, $points_y, $longitude_x, $latitude_y)){
              wc_add_notice( 
                sprintf( esc_html__('Delivery Service is Not Available in your Area..', 'woofood-plugin') , 
                  $woofood_delivery_hour_start, 
                  $woofood_delivery_hour_end
                ), 'error' 
              );
            }




          }


          else{

          //we cannot deliver// show message//
            wc_add_notice( 
              sprintf( esc_html__('Your Address seems to be invalid. Please check your address', 'woofood-plugin') , 
                $woofood_delivery_hour_start, 
                $woofood_delivery_hour_end
              ), 'error' 
            );


          }//end else












} //end else if order type is delivery


}

}//end function
//check distance on checkout//


}


if(!empty($woofood_postalcodes)  && ($woofood_distance_type  ==="postalcode") )
{

  add_action( 'woocommerce_checkout_process', 'wf_check_postalcode' );

  function wf_check_postalcode() {
 $woofood_core_is_enabled = woofood_core_is_enabled();
    if($woofood_core_is_enabled )
    {
    if(isset($_POST['woofood_order_type']) && $_POST['woofood_order_type'] =="pickup" )
    {

    }
    else
    {


     

      $options_woofood = get_option('woofood_options');
      $woofood_postalcodes = isset($options_woofood['woofood_postalcodes']) ? $options_woofood['woofood_postalcodes'] : null;
      $woofood_postalcodes = str_replace(" ", "", $woofood_postalcodes);
      $woofood_postalcodes = strtoupper($woofood_postalcodes);

      
      $woofood_current_postcode = isset($_POST['ship_to_different_address']) ? $_POST['shipping_postcode'] : $_POST['billing_postcode'];
      $woofood_current_postcode = str_replace(" ", "",  $woofood_current_postcode);
      $woofood_current_postcode = strtoupper($woofood_current_postcode);

      $postal_codes_array = explode(",",  trim($woofood_postalcodes));
      $woofood_check_postal_prefixes = apply_filters( 'woofood_check_postal_prefixes', false);



      if(!$woofood_check_postal_prefixes)
      {
        if(!in_array(trim($woofood_current_postcode), $postal_codes_array))
        {

         wc_add_notice( 
          sprintf( esc_html__('Delivery Service is Not Available in your Area..', 'woofood-plugin') , 
            $woofood_delivery_hour_start, 
            $woofood_delivery_hour_end
          ), 'error' 
        );

         

       }
     }
     else
     {

       if(is_array($postal_codes_array))
       {
        $matching_postal_code = false;

        foreach($postal_codes_array as $current_postal_code)
        {
          if (strpos($woofood_current_postcode, $current_postal_code) === 0) {


            $matching_postal_code =  true;
            
          }             


        }
        if(!$matching_postal_code)
        {
         wc_add_notice( 
          sprintf( esc_html__('Delivery Service is Not Available in your Area..', 'woofood-plugin') , 
            $woofood_delivery_hour_start, 
            $woofood_delivery_hour_end
          ), 'error' 
        );
       }


       


     }

   }





   

   
   



   


   











} //end else if order type is delivery



}
}//end function
//check distance on checkout//


}

function woofood_check_if_is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
{
  $points_polygon = count($vertices_y);
  $new_points = array();
  $i = 0;
  $point = array('x'=>$longitude_x, 'y'=> $latitude_y);
  for ($i = 0;  $i < $points_polygon; $i++) {

    $new_points[] = array('x'=> $vertices_x[$i], 'y'=>  $vertices_y[$i]);
  }

  $pointLocation = new WooFoodLocation();
  if($pointLocation->pointInPolygon($point, $new_points) =="inside" || $pointLocation->pointInPolygon($point, $new_points) =="vertex" )
  {
    return true;
  }
  else
  {
    return false;
  }

}
function woofood_check_if_is_in_polygon_before($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
{
  $points_polygon = $points_polygon -1;
  $i = $j = $c = 0;
  for ($i = 0, $j = $points_polygon ; $i < $points_polygon; $j = $i++) {
    if ( (($vertices_y[$i]  >  $latitude_y != ($vertices_y[$j] > $latitude_y)) &&
     ($longitude_x < ($vertices_x[$j] - $vertices_x[$i]) * ($latitude_y - $vertices_y[$i]) / ($vertices_y[$j] - $vertices_y[$i]) + $vertices_x[$i]) ) )
     $c = !$c;
 }
 return $c;
}
function woofood_check_if_is_in_polygon_new_tst($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
{
  $i = $j = $c = $point = 0;
  for ($i = 0, $j = $points_polygon ; $i < $points_polygon; $j = $i++) {
    $point = $i;
    if( $point == $points_polygon )
      $point = 0;
    if ( (($vertices_y[$point]  >  $latitude_y != ($vertices_y[$j] > $latitude_y)) &&
     ($longitude_x < ($vertices_x[$j] - $vertices_x[$point]) * ($latitude_y - $vertices_y[$point]) / ($vertices_y[$j] - $vertices_y[$point]) + $vertices_x[$point]) ) )
     $c = !$c;
 }
 return $c;
}

function woofood_check_if_is_in_polygon_tes_2($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
{
  $i = $j = $c = $point = 0;
  for ($i = 0, $j = $points_polygon ; $i < $points_polygon; $j = $i++) {
    $point = $i;
    if( $point == $points_polygon )
      $point = 0;
    if ( (($vertices_y[$point]  >  $latitude_y != ($vertices_y[$j] > $latitude_y)) &&
     ($longitude_x < ($vertices_x[$j] - $vertices_x[$point]) * ($latitude_y - $vertices_y[$point]) / ($vertices_y[$j] - $vertices_y[$point]) + $vertices_x[$point]) ) )
     $c = !$c;
 }
 return $c;
}
function woofood_check_if_is_in_polygon_test_2($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y){
  $i = $j = $c = $point = 0;
  for ($i = 0, $j = $points_polygon ; $i < $points_polygon; $j = $i++) {
    $point = $i;
    if( $point == $points_polygon )
      $point = 0;
    if ( (($vertices_y[$point]  >  $latitude_y != ($vertices_y[$j] > $latitude_y)) && ($longitude_x < ($vertices_x[$j] - $vertices_x[$point]) * ($latitude_y - $vertices_y[$point]) / ($vertices_y[$j] - $vertices_y[$point]) + $vertices_x[$point]) ) )
      $c = !$c;
  }
  return $c;
}


class WooFoodLocation {

  var $pointOnVertex = true; // Checar si el punto se encuentra exactamente en uno de los vértices?
  function pointInPolygon($point, $polygon, $pointOnVertex = true)
  {
    $this->pointOnVertex = $pointOnVertex;

      // Checar si el punto se encuentra exactamente en un vértice
    if ($this->pointOnVertex == true and $this->pointOnVertex($point, $polygon) == true) {
      return "vertex";
    }

      // Checar si el punto está adentro del poligono o en el borde
    $intersections = 0;
    $vertices_count = count($polygon);

    for ($i=1; $i < $vertices_count; $i++)
    {
      $vertex1 = $polygon[$i-1];
      $vertex2 = $polygon[$i];

          if ($vertex1['y'] == $vertex2['y'] && $vertex1['y'] == $point['y'] && $point['x'] > min($vertex1['x'], $vertex2['x']) && $point['x'] < max($vertex1['x'], $vertex2['x'])) { // Checar si el punto está en un segmento horizontal
            return "boundary";
          }

          if ($point['y'] > min($vertex1['y'], $vertex2['y']) && $point['y'] <= max($vertex1['y'], $vertex2['y']) && $point['x'] <= max($vertex1['x'], $vertex2['x']) && $vertex1['y'] != $vertex2['y']) {
            $xinters = ($point['y'] - $vertex1['y']) * ($vertex2['x'] - $vertex1['x']) / ($vertex2['y'] - $vertex1['y']) + $vertex1['x'];

              if ($xinters == $point['x']) { // Checar si el punto está en un segmento (otro que horizontal)
                return "boundary";
              }

              if ($vertex1['x'] == $vertex2['x'] || $point['x'] <= $xinters) {
                $intersections++;
              }
            }
          }

      // Si el número de intersecciones es impar, el punto está dentro del poligono.
          if ($intersections % 2 != 0) {
            return "inside";
          } else {
            return "outside";
          }
        }

        function pointOnVertex($point, $polygon)
        {
          foreach($polygon as $vertex)
          {
            if ($point == $vertex)
            {
              return true;
            }
          }

        }

      }

      ?>