<?php

function woofood_format_address($street, $number, $country = null)
{
  $exceptional_countries = array("KR", "ES", "GR", "AT", "SE");

  if(!empty($country))
  {
    if(in_array($country, $exceptional_countries))
    {
      return $street." ".$number;

    }
    else
    {
            return $number." ".$street;

    }

  }
  else
  {
                return $number." ".$street;

  }

}

function woofood_get_order_types()
{
      $order_types = array('delivery'=>esc_html__('Delivery', 'woofood-plugin'), 'pickup'=>esc_html__('Pickup', 'woofood-plugin'));

        return apply_filters( 'woofood_order_types_filter', $order_types);

}

function woofood_get_default_order_type()
{
        $default_order_type = "delivery";

        return apply_filters( 'woofood_default_order_type_filter', $default_order_type);

}

function woofood_get_order_type_by_key($key)
{
        $order_types = woofood_get_order_types();
        if(array_key_exists($key, $order_types))
        {
          return $order_types[$key];
        }

        return "";

}


function woofood_get_minutes_format($return_key = false)
{
  $minutes_format = array(
"default" => "'",
"mins" => esc_html__('mins', 'woofood-plugin'),
"minutes" => esc_html__('minutes', 'woofood-plugin')

  );
  $options_woofood = get_option('woofood_options');
  $woofood_minutes_display_format = isset($options_woofood["woofood_minutes_display_format"]) ? $options_woofood["woofood_minutes_display_format"] : null;

  if($woofood_minutes_display_format)
  {
    if($return_key)
{
      return $options_woofood["woofood_minutes_display_format"];

}
    return $minutes_format[$options_woofood["woofood_minutes_display_format"]];

  }
  else
  {
    if($return_key)
{
      return "default";

}
        return $minutes_format["default"];

  }

}


function woofood_core_is_enabled()
{
  return apply_filters("woofood_core_functionality_enabled", true);
 // return true;
}

function woofood_clear_transients()
{
    $all_transients = get_transient('woofood_all_transient_keys');

if(is_array($all_transients))
{
  foreach($all_transients as $transient)
  {
                delete_transient($transient);


  }
}
}

function woofood_check_customer_address_availability($full_address, $postal_code, $order_type)
{
      global $woocommerce;
      $delivery_available  = false; 
      $errors = "";
      $options_woofood = get_option('woofood_options');
      $woofood_google_distance_matrix_api_key = $options_woofood['woofood_google_distance_matrix_api_key'];
      $woofood_max_delivery_distance = $options_woofood['woofood_max_delivery_distance'];
      $woofood_distance_type = isset($options_woofood['woofood_distance_type']) ? $options_woofood['woofood_distance_type'] : "default";
      $woofood_postalcodes = isset($options_woofood['woofood_postalcodes']) ? $options_woofood['woofood_postalcodes'] : null;
      $woofood_polygon_area = isset($options_woofood['woofood_polygon_area']) ? $options_woofood['woofood_polygon_area'] : null;
      $woofood_store_address = $options_woofood['woofood_store_address'];


            //distance based checking//
          if(!empty($woofood_google_distance_matrix_api_key) && !empty($woofood_max_delivery_distance ) && !empty($woofood_store_address ) && $order_type!="pickup" && $woofood_distance_type =="default"  )
          {

            $details = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".urlencode($woofood_store_address)."&destinations=".urlencode($full_address)."&mode=driving&sensor=false&key=".$woofood_google_distance_matrix_api_key;
            $details = htmlspecialchars_decode($details);
            $details = str_replace("&amp;", "&", $details );
            $json = woofood_get_contents($details);

            $details = json_decode($json, TRUE);

            if(empty($details["error_message"]) && ($details['rows'][0]['elements'][0]["status"] != "ZERO_RESULTS" ) )
            {
              if($details['rows'][0]['elements'][0]['distance']['value'] || ($details['rows'][0]['elements'][0]['distance']['value'] == 0))
              {
                if (($details['rows'][0]['elements'][0]['distance']['value'] < $woofood_max_delivery_distance *1000)||($details['rows'][0]['elements'][0]['distance']['value'] == 0) )
                {
          //We can deliver /// 

                  $delivery_available  = true;  


                }

              }



              else{

                $delivery_available  = false; 



          }//end else
        }
        else{
          $delivery_available  = false; 

          $errors = $details["error_message"];

        }


      }
      //distance based checking end//





      //polygon based checking//  
      elseif(!empty($woofood_google_distance_matrix_api_key) && !empty($woofood_polygon_area ) && !empty($woofood_store_address ) && $order_type!="pickup" && $woofood_distance_type =="polygon"  )
      {

        $details = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($customer_address)."&key=".$woofood_google_distance_matrix_api_key."";
        $details = htmlspecialchars_decode($details);
        $details = str_replace("&amp;", "&", $details );
        $json = woofood_get_contents($details);
        $details = json_decode($json, TRUE);

        if(!empty($details["error_message"]))
        {
          $errors = $details["error_message"];
        }

        elseif ( !empty($details['results'][0]['geometry']['location']["lat"] ) && !empty($details['results'][0]['geometry']['location']["lng"] ))
        {
          $polygon_area_points  = json_decode($woofood_polygon_area , true);
          $points_x =array();
          $points_y =array();

          foreach($polygon_area_points as $current_point)
          {
            $points_x[] = $current_point["lng"];
            $points_y[] = $current_point["lat"];

          }

          $latitude_y =  $details['results'][0]['geometry']['location']["lat"];

          $longitude_x =  $details['results'][0]['geometry']['location']["lng"];
          $points_polygon = count($points_x);  // number vertices - zero-based array




              if (woofood_check_if_is_in_polygon($points_polygon, $points_x, $points_y, $longitude_x, $latitude_y)){
                $delivery_available = true;
              }
              else
              {
                $delivery_available = false;

              }




         }


    else{
      $delivery_available = false;

      //we cannot deliver// show message//



        }//end else






     }

   //polygon based checking end// 


      
      //postal code checking//
     elseif(!empty($woofood_postalcodes ) && !empty($woofood_store_address ) && $order_type!="pickup" && $woofood_distance_type =="postalcode"  )
     {

      $woofood_check_postal_prefixes = apply_filters( 'woofood_check_postal_prefixes', false);
      $woofood_postalcodes = str_replace(" ", "", $woofood_postalcodes);
      $woofood_postalcodes = strtoupper($woofood_postalcodes);
      $billing_postcode =  strtoupper($postal_code);

      $postal_codes_array = explode(",",  trim($woofood_postalcodes));

      if(!$woofood_check_postal_prefixes )
      {


        if(in_array(trim($billing_postcode), $postal_codes_array))
        {


          $delivery_available  = true;  



        }
        else
        {
          $delivery_available  = false;  

        }

      }
      else
      {
        $delivery_available  = false;  
        foreach($postal_codes_array as $current_postal_code)
        {
          if (strpos($billing_postcode, $current_postal_code) === 0) {


            $delivery_available  = true;  

          }             


        }



      }








    }
    else
    {
          $delivery_available  = true;  

    }
    //postal code checking end//

    return array("availability"=>$delivery_available, "errors"=>$error_message);
   }

?>