<?php
defined('ABSPATH') or die;

require_once dirname(__FILE__) . '/class-np-shortcodes.php';
require_once dirname(__FILE__) . '/class-np-svg-uploader.php';

class Mediaspot_zopyron {

    /**
     * Filter on the_content
     *
     * @param string $content
     *
     * @return string
     */
    public static function theContentFilter($content) {
        $post = get_post();
        //if $content not post content we need only return
        if ($content === '' && $post->post_content !== '') {
            return $content;
        }
        if ($post) {
            $sections_html = self::html($post->ID);
            if ($sections_html) {
                $content = $sections_html;
            }
        }
        return $content;
    }

    /**
     * Html preg_replace_callback callback
     *
     * @param array $code_php
     *
     * @return string
     */
    private static function _phpReplaceHtml($code_php) {
        if (stripos($code_php[1], '<?php') === 0 && stripos($code_php[1], '?>') === strlen($code_php[1])-2) {
            $code_php[1] = str_replace("<?php", "", $code_php[1]);
            $code_php[1] = str_replace("?>", "", $code_php[1]);
            ob_start();
            eval($code_php[1]);
            $string = ob_get_contents();
            ob_end_clean();
            $code_php[1] = $string;
        } elseif (stripos($code_php[1], '<?php') === 0 && stripos($code_php[1], '?>') !== strlen($code_php[1])-2 OR stripos($code_php[1], '<?php') !== 0 && stripos($code_php[1], '<?php') !== false) {
            /* For more than one opening and closing php tags and attempts to insert html */
            preg_match_all("/(<\?([\s\S]+?)?>)/", $code_php[1], $matches);
            $code_php[1] = "";
            foreach ($matches[0] as &$element_php) {
                $code_php[1] = $code_php[1].$element_php;
            }
            $code_php[1] = str_replace("<?php", "", $code_php[1]);
            $code_php[1] = str_replace("?>", "", $code_php[1]);
            ob_start();
            eval($code_php[1]);
            $string = ob_get_contents();
            ob_end_clean();
            $code_php[1] = $string;
        }
        return $code_php[1];
    }

    /**
     * Get processed publishHtml for page
     *
     * @param string|int $post_id
     *
     * @return string
     */
    public static function html($post_id) {
        if (! post_password_required($post_id)) {
            $sections_html = np_data_provider($post_id)->getPagePublishHtml();
        } else {
            return "<div style='text-align:center'>".get_the_password_form($post_id)."</div>";
        }

        if ($sections_html) {
            $sections_html = self::processFormCustomPhp($sections_html, $post_id);
            $sections_html = self::processContent($sections_html, false);
            if (self::isAutoResponsive($post_id)) {
                $sections_html = self::_getAutoResponsiveScript($post_id) . $sections_html;
            }
            if (!self::isNpTheme()) {
                $template_page = NpMetaOptions::get($post_id, 'np_template');
                if ($template_page == "html") {
                    $sections_html = '<div class="' . implode(' ', self::bodyClassFilter(array())) . '" style="' . self::bodyStyleFilter() . '">' . $sections_html . "</div>";
                } else {
                    $sections_html = '<div class="mediaspot_zopyron-container"><div class="' . implode(' ', self::bodyClassFilter(array())) . '" style="' . self::bodyStyleFilter() . '">' . $sections_html . "</div></div>";
                }
            }
        }

        return $sections_html;
    }

    /**
     * Filter on body_class
     *
     * Add page classes to <body>
     *
     * @param string[] $classes
     *
     * @return string[]
     */
    public static function bodyClassFilter($classes) {
        if (self::isHtmlQuery()) {
            return $classes;
        }

        $post = get_post();
        if ($post) {
            $class = np_data_provider($post->ID)->getPageBodyClass();
            if ($class && is_singular()) {
                $classes[] = $class;

                if (self::isAutoResponsive($post->ID)) {
                    $initial_mode = self::_getInitialResponsiveMode($post->ID);
                    foreach (array_reverse(self::$responsiveModes) as $mode) {
                        $classes[] = self::$responsiveBorders[$mode]['CLASS'];

                        if ($mode === $initial_mode) {
                            break;
                        }
                    }
                }
            }
        }
        return $classes;
    }

    /**
     * Filter on body style
     *
     * Add page style attribute to <body>
     *
     * @return string
     */
    public static function bodyStyleFilter() {
        $post = get_post();
        if ($post) {
            $style = np_data_provider($post->ID)->getPageBodyStyle();
            return $style && is_singular() ? $style : '';
        }
        return '';
    }

    /**
     * Action on wp_footer
     * Print backlink html
     */
    public static function wpFooterAction() {
        $post = get_post();
        if ($post) {
            $backlink = np_data_provider($post->ID)->getPageBacklink();
            if ($backlink && get_option('np_hide_backlink')) {
                // back compat for old versions
                // backlink's html isn't empty even np_hide_backlink is true
                $backlink = str_replace('u-backlink', 'u-backlink u-hidden', $backlink);
            }
            echo $backlink;

            $bodyClass = implode(' ', self::bodyClassFilter(array()));
            $bodyStyle = self::bodyStyleFilter();
            $template = '<div class="mediaspot_zopyron-container"><div class="' . $bodyClass . '" style="' . $bodyStyle . '">{content}</div></div>';

            $data_provider = np_data_provider($post->ID);
            $sections_html = $data_provider->getPagePublishHtml();
            $cookiesConsent = NpMeta::get('cookiesConsent') ? json_decode(NpMeta::get('cookiesConsent'), true) : '';
            if ($cookiesConsent && (!$cookiesConsent['hideCookies'] || $cookiesConsent['hideCookies'] === 'false') && $sections_html && !self::isNpTheme()) {
                echo str_replace('{content}', $cookiesConsent['publishCookiesSection'], $template);
            }

            $hideBackToTop = $data_provider->getHideBackToTop();
            if (!$hideBackToTop) {
                echo str_replace('{content}', NpMeta::get('backToTop'), $template);
            }
        }
    }

    /**
     * Function for publish_html postprocessing
     *
     * @param string $content
     * @param bool   $isPublic
     * @param string $templateName
     *
     * @return mixed|string
     **/
    public static function processContent($content, $isPublic = true, $templateName = '') {
        //$content = self::_productLinksFilter($content);
        if ($isPublic) {
            $content = self::processControls($content);
        }
        $content = self::_processForms($content, $templateName);
        $content = self::_prepareShortcodes($content);
        $content = self::_prepareCustomPhp($content);
        $content = do_shortcode($content);
        $content = NpWidgetsImporter::processLink($content);
        return $content;
    }

    /**
     * @param string $content
     * @param string $pageId
     */
    public static function processFormCustomPhp($content, $pageId) {
        if ($pageId) {
            $plgDir = dirname(plugins_url('', __FILE__));
            $formFile = $plgDir . '/templates/form.php';
            $content = preg_replace(
                '/(<form[^>]*action=[\'\"]+)\[\[form\-(.*?)\]\]([\'\"][^>]*source=[\'\"]customphp)/',
                '$1' . $formFile . '?id=' . $pageId . '&formId=$2$3',
                $content
            );
        }
        return $content;
    }

    /**
     * Process custom php controls
     *
     * @param string $content
     *
     * @return string
     */
    private static function _prepareCustomPhp($content) {
        return preg_replace_callback('/<!--custom_php-->([\s\S]+?)<!--\/custom_php-->/', 'Mediaspot_zopyron::_phpReplaceHtml', $content);
    }

    private static $_formIdx;
    private static $_formsSources;

    /**
     * Process forms
     *
     * @param string $content
     * @param string $templateName
     *
     * @return string
     */
    private static function _processForms($content, $templateName = '') {
        global $post;
        self::$_formIdx = 0;
        self::$_formsSources = NpForms::getPageForms($post->ID, $templateName);
        return preg_replace_callback(NpForms::$formRe, 'Mediaspot_zopyron::_processForm', $content);
    }

    /**
     * Convert HTML-placeholders into shortcodes
     *
     * @param string $content
     *
     * @return string
     */
    private static function _prepareShortcodes($content) {
        $content = preg_replace('#<!--(\/?)(position|block|block_header|block_header_content|block_content_content)-->#', '[$1np_$2]', $content);
        return $content;
    }

    /**
     * Process form
     * Callback for preg_replace_callback
     *
     * @param array $match
     *
     * @return string
     */
    private static function _processForm($match) {
        $form_html = $match[0];
        $form_id = isset(self::$_formsSources[self::$_formIdx]['id']) ? self::$_formsSources[self::$_formIdx]['id'] : 0;

        $return = NpForms::getHtml($form_id, $form_html);
        if (self::$_formIdx === 0) {
            $return = NpForms::getScriptsAndStyles() . "\n" . $return;
        }
        self::$_formIdx++;
        return $return;
    }

    /**
     * Process product add-to-cart links
     *
     * @param string $html
     *
     * @return string
     */
    private static function _productLinksFilter($html) {
        if (!function_exists('wc_get_product')) {
            return $html;
        }

        return preg_replace_callback('#<a(.*?)</a>#', 'Mediaspot_zopyron::_productLinksFilterCallback', $html);
    }

    /**
     * _productLinksFilter preg_replace_callback callback
     *
     * @param array $match
     *
     * @return string
     */
    private static function _productLinksFilterCallback($match) {
        if (preg_match('#href="\#product-(\d+)#', $match[1], $m)) {
            $product_id = (int) $m[1];

            if (preg_match('#class="([^"]*)"#', $match[1], $m)) {
                $class = $m[1];
            } else {
                $class = '';
            }
            global $product;
            $prev_product = $product;
            $product = wc_get_product($product_id);
            ob_start();
            woocommerce_template_loop_add_to_cart();
            $product = $prev_product;
            $add_to_cart_html = ob_get_clean();
            $add_to_cart_html = str_replace('class="button', 'class="' . $class, $add_to_cart_html);
            return $add_to_cart_html;
        }
        return $match[0];
    }

    /**
     * Filter on template_include
     * Switch to 'html' or 'html-header-footer' template
     *
     * @param string $template_path
     *
     * @return string
     */
    public static function templateFilter($template_path) {
        global $post;
        if ($post && is_singular() && np_data_provider($post->ID)->isMediaspot_zopyron()) {
            $np_template = NpMetaOptions::get($post->ID, 'np_template');
            $np_template = apply_filters('mediaspot_zopyron_template', $np_template, $post->ID, $template_path);
            if ($np_template) {
                $template_path = dirname(__FILE__) . "/../templates/$np_template.php";
            }
        }
        return $template_path;
    }

    /**
     * Check is it query for getting dummy page
     * Dummy page - it's a page without Mediaspot_zopyron styles
     * used for getting real typography properties from theme
     *
     * @return bool
     */
    public static function isHtmlQuery() {
        return !empty($_GET['np_html']);
    }

    /**
     * Add cookies confirm code
     */
    public static function addCookiesConfirmCode()
    {
        global $post;
        $sections_html = np_data_provider($post->ID)->getPagePublishHtml();
        $cookiesConsent = NpMeta::get('cookiesConsent') ? json_decode(NpMeta::get('cookiesConsent'), true) : '';
        if ($cookiesConsent && (!$cookiesConsent['hideCookies'] || $cookiesConsent['hideCookies'] === 'false') && $sections_html && !self::isNpTheme()) {
            echo $cookiesConsent['cookieConfirmCode'];
        }
    }

    /**
     * Action on wp_head
     */
    public static function addHeadStyles() {
        if (self::isHtmlQuery() || !is_singular()) {
            return;
        }

        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);
        $siteSettings = $data_provider->getSiteSettings();
        echo $data_provider->getPageFonts();

        $styles = $data_provider->getPageHead();
        if (self::isAutoResponsive($post_id)) {
            $styles = preg_replace('#\/\*RESPONSIVE_MEDIA\*\/([\s\S]*?)\/\*\/RESPONSIVE_MEDIA\*\/#', '', $styles);
        } else {
            $styles = preg_replace('#\/\*RESPONSIVE_CLASS\*\/([\s\S]*?)\/\*\/RESPONSIVE_CLASS\*\/#', '', $styles);
        }

        if (self::isNpTheme()) {
            echo "<style>\n$styles</style>\n";
        } else {
            global $post;
            $template_page = NpMetaOptions::get($post->ID, 'np_template');
            if ($template_page != "html") {
                echo  "<style>\n".preg_replace_callback('/([^{}]+)\{[^{}]+?\}/', 'self::addContainerForConflictStyles', $styles)."</style>\n";
            } else {
                echo "<style>\n$styles</style>\n";
            }
        }

        $description = $data_provider->getPageDescription();
        if (isset($siteSettings->description) && $siteSettings->description && strpos($description, $siteSettings->description) === false) {
            if ($description !== '') {
                $description = $siteSettings->description . ', ' . $description;
            } else {
                $description = $siteSettings->description;
            }

        }
        if ($description) {
            echo "<meta name=\"description\" content=\"$description\">\n";
        }

        $keywords = $data_provider->getPageKeywords();
        if (isset($siteSettings->keywords) && $siteSettings->keywords && strpos($keywords, $siteSettings->keywords) === false) {
            if ($keywords !== '') {
                $keywords = $siteSettings->keywords . ', ' . $keywords;
            } else {
                $keywords = $siteSettings->keywords;
            }
        }
        if ($keywords) {
            echo "<meta name=\"keywords\" content=\"$keywords\">\n";
        }

        $meta_tags = $data_provider->getPageMetaTags();
        if ($meta_tags) {
            echo $meta_tags . "\n";
        }

        $customHeadHtml = $data_provider->getPageCustomHeadHtml();
        if ($customHeadHtml) {
            echo $customHeadHtml . "\n";
        }
    }

    /**
     * Action on wp_head
     */
    public static function addHeadStyles2() {
        if (self::isHtmlQuery()) {
            return;
        }

        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);

        if (is_singular() && $data_provider->isMediaspot_zopyron()) {
            $site_style_css = $data_provider->getStyleCss();
            if ($site_style_css) {
                if (self::isNpTheme()) {
                    $site_style_css = preg_replace('#<style.*?(typography|font-scheme|color-scheme)="Theme [\s\S]*?<\/style>#', '', $site_style_css);
                } else {
                    global $post;
                    $template_page = NpMetaOptions::get($post->ID, 'np_template');
                    if ($template_page != "html") {
                        $site_style_css = preg_replace_callback('/([^{}]+)\{[^{}]+?\}/', 'self::addContainerForConflictStyles', $site_style_css);
                    }
                }
                echo "<style>$site_style_css</style>\n";
            }
        }
    }
    /**
     * Add container for conflict styles
     *
     * @param array $match
     *
     * @return string
     */
    public static function addContainerForConflictStyles($match) {
        $selectors = $match[1];
        $parts = explode(',', $selectors);
        $newSelectors = implode(
            ',',
            array_map(
                function ($part) {
                    if (!preg_match('/html|body|sheet|keyframes/', $part)) {
                        return ' .mediaspot_zopyron-container ' . $part;
                    } else {
                        return $part;
                    }
                },
                $parts
            )
        );
        return str_replace($selectors, $newSelectors, $match[0]);
    }

    /**
     * Add viewport meta tag
     */
    public static function addViewportMeta() {
        if (self::isHtmlQuery()) {
            return;
        }
        echo <<<SCRIPT
<script>
    if (!document.querySelector("meta[name='viewport")) {
        var vpMeta = document.createElement('meta');
        vpMeta.name = "viewport";
        vpMeta.content = "width=device-width, initial-scale=1.0";
        document.getElementsByTagName('head')[0].appendChild(vpMeta);
    }
</script>
SCRIPT;
    }

    /**
     * Add site meta tags
     */
    public static function addSiteMetaTags() {
        if (self::isHtmlQuery()) {
            return;
        }
        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);
        $siteSettings = $data_provider->getSiteSettings();
        if (isset($siteSettings->metaTags) && $siteSettings->metaTags) {
            echo $siteSettings->metaTags;
        }
    }

    /**
     * Add site custom css
     */
    public static function addSiteCustomCss() {
        if (self::isHtmlQuery()) {
            return;
        }
        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);
        $siteSettings = $data_provider->getSiteSettings();
        if (isset($siteSettings->customCss) && $siteSettings->customCss) {
            echo '<style>' . $siteSettings->customCss . '</style>';
        }
    }

    /**
     * Add site custom html
     */
    public static function addSiteCustomHtml() {
        if (self::isHtmlQuery()) {
            return;
        }
        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);
        $siteSettings = $data_provider->getSiteSettings();
        if (isset($siteSettings->headHtml) && $siteSettings->headHtml) {
            echo $siteSettings->headHtml;
        }
    }

    /**
     * Add site analytic
     */
    public static function addSiteAnalytic() {
        if (self::isHtmlQuery()) {
            return;
        }
        $post_id = get_the_ID();
        $data_provider = np_data_provider($post_id);
        $siteSettings = $data_provider->getSiteSettings();
        if (isset($GLOBALS['googleAnalyticsMarker']) && !$GLOBALS['googleAnalyticsMarker'] && isset($siteSettings->analyticsCode)) {
            echo $siteSettings->analyticsCode;
        }
    }

    /**
     * Check if need to enable auto-responsive
     *
     * @param string|int $page_id
     *
     * @return bool
     */
    public static function isAutoResponsive($page_id) {
        if (self::isNpTheme()) {
            return false;
        }
        if (NpMetaOptions::get($page_id, 'np_template') === 'html') {
            return false;
        }
        return !!NpSettings::getOption('np_auto_responsive');
    }

    /**
     * Filter on single_post_title
     *
     * @param string  $title
     * @param WP_Post $post
     *
     * @return string
     */
    public static function singlePostTitleFilter($title, $post) {
        $post_id = $post->ID;
        $custom_title = np_data_provider($post_id)->getPageTitleInBrowser();
        if ($custom_title) {
            $title = $custom_title;
        }
        return $title;
    }

    /**
     * Action on wp_enqueue_scripts
     */
    public static function addScriptsAndStylesAction() {
        global $post;
        if (self::isHtmlQuery() || !np_data_provider($post->ID)->isMediaspot_zopyron()) {
            return;
        }

        if (NpSettings::getOption('np_include_jquery')) {
            wp_register_script("mediaspot_zopyron-jquery", APP_PLUGIN_URL . 'assets/js/jquery.js', array(), APP_PLUGIN_VERSION);
            wp_enqueue_script("mediaspot_zopyron-jquery");

            wp_register_script("mediaspot_zopyron-script", APP_PLUGIN_URL . 'assets/js/mediaspot_zopyron.js', array('mediaspot_zopyron-jquery'), APP_PLUGIN_VERSION);
        } else {
            wp_register_script("mediaspot_zopyron-script", APP_PLUGIN_URL . 'assets/js/mediaspot_zopyron.js', array('jquery'), APP_PLUGIN_VERSION);
        }

        if (self::isNpTheme()) {
            wp_register_style("mediaspot_zopyron-style", APP_PLUGIN_URL . 'assets/css/mediaspot_zopyron.css', array(), APP_PLUGIN_VERSION);
            wp_enqueue_style("mediaspot_zopyron-style");
        } else {
            $template_page = NpMetaOptions::get($post->ID, 'np_template');
            if ($template_page == "html") {
                wp_register_style("mediaspot_zopyron-style", APP_PLUGIN_URL . 'assets/css/mediaspot_zopyron.css', array(), APP_PLUGIN_VERSION);
                wp_enqueue_style("mediaspot_zopyron-style");
            } else {
                wp_register_style("mediaspot_zopyron-style", APP_PLUGIN_URL . 'assets/css/page-styles.css', array(), APP_PLUGIN_VERSION);
                wp_enqueue_style("mediaspot_zopyron-style");
            }
            //if our theme this scripts not need
            wp_enqueue_script("mediaspot_zopyron-script");
        }

        if (is_singular()) {
            if (self::isAutoResponsive($post->ID)) {
                wp_register_style("mediaspot_zopyron-responsive", APP_PLUGIN_URL . 'assets/css/responsive.css', APP_PLUGIN_VERSION);
                wp_enqueue_style("mediaspot_zopyron-responsive");
            } else {
                wp_register_style("mediaspot_zopyron-media", APP_PLUGIN_URL . 'assets/css/media.css', APP_PLUGIN_VERSION);
                wp_enqueue_style("mediaspot_zopyron-media");
            }
        }
    }

    public static $responsiveModes = array('XS', 'SM', 'MD', 'LG', 'XL');
    public static $responsiveBorders = array(
        'XL' => array(
            'CLASS' => 'u-xl',
            'MAX' => 1000000,
        ),
        'LG' => array(
            'CLASS' => 'u-lg',
            'MAX' => 1199,
        ),
        'MD' => array(
            'CLASS' => 'u-md',
            'MAX' => 991,
        ),
        'SM' => array(
            'CLASS' => 'u-sm',
            'MAX' => 767,
        ),
        'XS' => array(
            'CLASS' => 'u-xs',
            'MAX' => 575,
        ),
    );

    /**
     * Get initial responsive mode using $GLOBALS['content_width']
     *
     * @param string|int $post_id
     *
     * @return mixed|string
     */
    private static function _getInitialResponsiveMode($post_id) {
        if (!self::isAutoResponsive($post_id)) {
            return 'XL';
        }
        if (NpMetaOptions::get($post_id, 'np_template')) {
            return 'XL';
        }

        global $content_width;
        if (!isset($content_width) || !$content_width) {
            return 'XL';
        }

        $width = (int) $content_width;

        foreach (self::$responsiveModes as $mode) {
            if ($width <= self::$responsiveBorders[$mode]['MAX']) {
                return $mode;
            }
        }
        return 'XL';
    }

    /**
     * Auto-responsive script
     *
     * @param int|string $post_id
     *
     * @return string
     */
    private static function _getAutoResponsiveScript($post_id) {
        ob_start();
        ?>
        <script>
            (function ($) {
                var ResponsiveCms = window.ResponsiveCms;
                if (!ResponsiveCms) {
                    return;
                }
                ResponsiveCms.contentDom = $('script:last').parent();
                ResponsiveCms.prevMode = <?php echo wp_json_encode(self::_getInitialResponsiveMode($post_id)); ?>;

                if (typeof ResponsiveCms.recalcClasses === 'function') {
                    ResponsiveCms.recalcClasses();
                }
            })(jQuery);
        </script>
        <?php
        return ob_get_clean();
    }

    /**
     * Action on init
     */
    public static function initAction() {
        if (self::isNpTheme()) {
            add_filter('body_class', 'Mediaspot_zopyron::bodyClassFilter');
            add_filter('add_body_style_attribute', 'Mediaspot_zopyron::bodyStyleFilter');
        }
    }

    /**
     * Check is it Mediaspot_zopyron theme
     *
     * @return bool
     */
    public static function isNpTheme() {
        if (self::$_themeSettings === null) {
            self::$_themeSettings = apply_filters('np_theme_settings', array());
        }
        return !!self::$_themeSettings;
    }
    private static $_themeSettings = null;

    /**
     * Initialize svg upload with sizes
     */
    public static function svgUploaderInitialization() {
        new NpSvgUploader();
    }

    public static $controlName = '';
    /**
     * Process all custom controls on the header
     *
     * @param string $content content
     *
     * @return mixed
     */
    public static function processControls($content) {
        $controls = array('headline', 'logo', 'menu', 'search', 'position', 'headerImage', 'slogan', 'widget', 'shortCode');
        foreach ($controls as $value) {
            self::$controlName = $value;
            $content =  preg_replace_callback(
                '/<\!--np_' . $value . '--><!--np_json-->([\s\S]+?)<\!--\/np_json-->([\s\S]*?)<\!--\/np_' . $value . '-->/',
                function ($matches) {
                    $controlProps = json_decode(trim($matches[1]), true);
                    $controlTemplate = $matches[2];
                    ob_start();
                    include APP_PLUGIN_PATH . '/includes/controls/'. self::$controlName . '/' . self::$controlName . '.php';
                    return ob_get_clean();
                },
                $content
            );
        }
        return $content;
    }

    /**
     * Add recaptcha script when not contact 7 plugin
     */
    public static function enableRecapcha() {
        if (self::isHtmlQuery()) {
            return;
        }
        $site_settings = json_decode(NpMeta::get('site_settings'));
        if (!class_exists('WPCF7') && isset($site_settings->captchaSiteKey) && isset($site_settings->captchaSecretKey) && isset($site_settings->captchaScript) && $site_settings->captchaSiteKey !== "" && $site_settings->captchaSecretKey !== "") {
            echo $site_settings->captchaScript;
        }
    }
}

add_action('init', 'Mediaspot_zopyron::initAction');
add_filter('the_content', 'Mediaspot_zopyron::theContentFilter');
add_action('wp_footer', 'Mediaspot_zopyron::wpFooterAction', 1001);
add_action('wp_enqueue_scripts', 'Mediaspot_zopyron::addScriptsAndStylesAction', 9); // add before theme styles
add_action('wp_head', 'Mediaspot_zopyron::addHeadStyles');
add_action('wp_head', 'Mediaspot_zopyron::addCookiesConfirmCode');
add_action('wp_head', 'Mediaspot_zopyron::addHeadStyles2', 1003);
add_action('wp_head', 'Mediaspot_zopyron::addViewportMeta', 1004);
add_action('wp_head', 'Mediaspot_zopyron::addSiteMetaTags', 1005);
add_action('wp_head', 'Mediaspot_zopyron::addSiteCustomCss', 1006);
add_action('wp_head', 'Mediaspot_zopyron::addSiteCustomHtml', 1007);
add_action('wp_head', 'Mediaspot_zopyron::addSiteAnalytic', 1008);
add_action('wp_head', 'Mediaspot_zopyron::enableRecapcha', 1009);
add_filter('template_include', 'Mediaspot_zopyron::templateFilter');
add_filter('single_post_title', 'Mediaspot_zopyron::singlePostTitleFilter', 9, 2);
add_action('admin_init', 'Mediaspot_zopyron::svgUploaderInitialization');
add_action('admin_init', 'NpImport::redirectToPluginWizard');
add_action(
    'in_admin_header', function () {
        $pagename = get_admin_page_title();
        if ($pagename !== APP_PLUGIN_WIZARD_NAME) {
            return;
        }
        remove_all_actions('admin_notices');
        remove_all_actions('all_admin_notices');
        wp_enqueue_style('pwizard-style', APP_PLUGIN_URL . 'importer/assets/css/pwizard-admin-style.css', array(), '');
    }, 1000
);
// For UP-6583 form temporary fix
if (function_exists('w123cf_widget_text_filter')) {
    add_filter('the_content', 'w123cf_widget_text_filter', 1005);
}

if (Mediaspot_zopyron::isHtmlQuery()) {
    show_admin_bar(false);
}