/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { BlockControls, InspectorControls, ServerSideRender, PlainText, MediaUpload, PanelColorSettings } from '@wordpress/editor';
import {
	Button,
	Disabled,
	PanelBody,
	Placeholder,
	RangeControl,
	Toolbar,
	TextControl,
	withSpokenMessages,
} from '@wordpress/components';
import { Component, Fragment } from '@wordpress/element';
import PropTypes from 'prop-types';

/**
 * Internal dependencies
 */
import GridContentControl from '../../components/grid-content-control';
import { IconWidgets } from '../../components/icons';
import ProductsControl from '../../components/products-control';
import ProductOrderbyControl from '../../components/product-orderby-control';

/**
 * Component to handle edit mode of "Hand-picked Products".
 */
class WooFoodAccordionHandPicked extends Component {
	getInspectorControls() {
		const { attributes, setAttributes } = this.props;
		const { columns, contentVisibility, orderby } = attributes;


		const onChangeTitle = ( newContent ) => {
			setAttributes( { title: newContent } );
		};

		return (
			<InspectorControls key="inspector">


<PanelBody title={ __( 'WooFood Accordion Settings', 'woofood' ) } >
      <TextControl
        label={ __( 'Accordion Title', 'woofood' ) }
        value={ attributes.title }
        onChange={ onChangeTitle }
        help={ __( 'Set the accordion title', 'woofood' ) }
      />
     


               
    </PanelBody>
        <strong>{ __( 'Icon Settings', 'woofood' ) }</strong>


                    <img src={this.props.attributes.icon} alt="" />

 <MediaUpload

           onSelect={(imageObject) => (
            console.log(imageObject),
              this.props.setAttributes({
                      icon: imageObject.sizes.full.url,
                    })

           )}

           
            type="image"
            //value={backgroundImage} // make sure you destructured backgroundImage from props.attributes!
            render={({ open }) => (
              <div>
                <button onClick={open}>
                    { __( 'Upload Icon', 'woofood' ) }
                </button>
                  <button onClick={this.props.removeIcon}>
                    { __( 'Remove Icon', 'woofood' ) }
                </button>
                </div>

            )}
        />

     <PanelColorSettings
              title={__('Color Settings', 'woofood')}
              initialOpen={false}
              colorSettings={[
                {
                  value: this.props.attributes.BackgroundColor,
                  onChange: value =>
                    this.props.setAttributes({
                      BackgroundColor: value,
                    }),
                  label: __(' Background Color', 'woofood'),
                },
                {
                  value: this.props.attributes.titleTextColor,
                  onChange: value =>
                    this.props.setAttributes({
                      titleTextColor: value,
                    }),
                  label: __('Title Text Color', 'woofood'),
                },
                {
                  value: this.props.attributes.borderColor,
                  onChange: value =>
                    this.props.setAttributes({
                      borderColor: value,
                    }),
                  label: __('Border Color', 'woofood'),
                },
              ]}
            />







				<PanelBody
					title={ __( 'Layout', 'woo-gutenberg-products-block' ) }
					initialOpen
				>
					<RangeControl
						label={ __( 'Columns', 'woo-gutenberg-products-block' ) }
						value={ columns }
						onChange={ ( value ) => setAttributes( { columns: value } ) }
						min={ wc_product_block_data.min_columns }
						max={ wc_product_block_data.max_columns }
					/>
				</PanelBody>
				<PanelBody
					title={ __( 'Content', 'woo-gutenberg-products-block' ) }
					initialOpen
				>
					<GridContentControl
						settings={ contentVisibility }
						onChange={ ( value ) => setAttributes( { contentVisibility: value } ) }
					/>
				</PanelBody>
				<PanelBody
					title={ __( 'Order By', 'woo-gutenberg-products-block' ) }
					initialOpen={ false }
				>
					<ProductOrderbyControl
						setAttributes={ setAttributes }
						value={ orderby }
					/>
				</PanelBody>
				<PanelBody
					title={ __( 'Products', 'woo-gutenberg-products-block' ) }
					initialOpen={ false }
				>
					<ProductsControl
						selected={ attributes.products }
						onChange={ ( value = [] ) => {
							const ids = value.map( ( { id } ) => id );
							setAttributes( { products: ids } );
						} }
					/>
				</PanelBody>
			</InspectorControls>
		);
	}

	renderEditMode() {
		const { attributes, debouncedSpeak, setAttributes } = this.props;
		const onDone = () => {
			setAttributes( { editMode: false } );
			debouncedSpeak(
				__(
					'Showing Hand-picked Products block preview.',
					'woo-gutenberg-products-block'
				)
			);
		};

		return (
			<Placeholder
				icon={ <IconWidgets /> }
				label={ __( 'Hand-picked Products', 'woo-gutenberg-products-block' ) }
				className="wc-block-products-grid wc-block-handpicked-products"
			>
				{ __(
					'Display a selection of hand-picked products in a grid',
					'woo-gutenberg-products-block'
				) }
				<div className="wc-block-handpicked-products__selection">
					<ProductsControl
						selected={ attributes.products }
						onChange={ ( value = [] ) => {
							const ids = value.map( ( { id } ) => id );
							setAttributes( { products: ids } );
						} }
					/>
					<Button isDefault onClick={ onDone }>
						{ __( 'Done', 'woo-gutenberg-products-block' ) }
					</Button>
				</div>
			</Placeholder>
		);
	}

	render() {
		const { attributes, setAttributes } = this.props;
		const { editMode } = attributes;

		return (
			<Fragment>
				<BlockControls>
					<Toolbar
						controls={ [
							{
								icon: 'edit',
								title: __( 'Edit' ),
								onClick: () => setAttributes( { editMode: ! editMode } ),
								isActive: editMode,
							},
						] }
					/>
				</BlockControls>
				{ this.getInspectorControls() }
				{ editMode ? (
					this.renderEditMode()
				) : (

				<div className={this.props.className}>
        <div className='woofood-accordion'>
          <a className data-toggle="collapse" data-target={'#'+(encodeURIComponent('wf-accordion-'+this.props.attributes.title)).replace(/%/g,'')} href={'#'+(encodeURIComponent('wf-accordion-'+this.props.attributes.title)).replace(/%/g,'')} aria-expanded="true" aria-controls="collapseThree"> 
            <div className="panel-heading panel-heading-title "  style={{
              background: this.props.attributes.BackgroundColor || undefined,
              borderColor: this.props.attributes.borderColor || undefined,
            }}>

            
      
      { !! this.props.attributes.icon.length > 0 &&  <img src={this.props.attributes.icon} /> }
              

              <h4 className="panel-title">
               <PlainText
            
        onChange={ ( value = [] ) => {
							setAttributes( { title: value } );
						} }

                value={this.props.attributes.title}
                style={{ color: this.props.attributes.titleTextColor || undefined}}
                />                 </h4>

                 <div className="accordion-plus-icon">
                <i className="woofood-icon-plus-circled rotate-icon" style={{ color: this.props.attributes.titleTextColor || undefined}} /> 
              </div> 
            </div>
          </a>   
           <div id={(encodeURIComponent('wf-accordion-'+this.props.attributes.title)).replace(/%/g,'')} className="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingThree" aria-expanded="true" style={{}}>
          <div className="panel-body">
       <Disabled>
						<ServerSideRender block="woofood/accordion-handpicked" attributes={ attributes }/>
					</Disabled>
          </div>
        </div>
        </div>
 </div>

				) }
			</Fragment>
		);
	}
}

WooFoodAccordionHandPicked.propTypes = {
	/**
	 * The attributes for this block
	 */
	attributes: PropTypes.object.isRequired,
	/**
	 * The register block name.
	 */
	name: PropTypes.string.isRequired,
	/**
	 * A callback to update attributes
	 */
	setAttributes: PropTypes.func.isRequired,
	// from withSpokenMessages
	debouncedSpeak: PropTypes.func.isRequired,
};

export default withSpokenMessages( WooFoodAccordionHandPicked );
