<?php
defined('ABSPATH') or die;

class NpMeta {

    public static $baseTableName = 'mediaspot_zopyron_meta';
    public static $_cache = array();

    /**
     * Initialize method
     */
    public static function init() {
        global $wpdb;
        $wpdb->mediaspot_zopyron_meta = $wpdb->prefix . self::$baseTableName;

        self::updateTable();
    }

    /**
     * Get mediaspot_zopyron_meta value
     *
     * @param string $meta_key
     * 
     * @return string|false
     */
    public static function get($meta_key) {
        if (!isset(self::$_cache[$meta_key])) {
            global $wpdb;
            self::$_cache[$meta_key] = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM $wpdb->mediaspot_zopyron_meta WHERE meta_key=%s", $meta_key));
        }
        return self::$_cache[$meta_key];
    }

    /**
     * Update mediaspot_zopyron_meta value
     *
     * @param string $meta_key
     * @param string $meta_value
     */
    public static function update($meta_key, $meta_value) {
        global $wpdb;

        // TODO: may be optimize using UPDATE
        $wpdb->query($wpdb->prepare("DELETE FROM $wpdb->mediaspot_zopyron_meta WHERE meta_key=%s", $meta_key));
        $wpdb->query($wpdb->prepare("INSERT INTO $wpdb->mediaspot_zopyron_meta (meta_key, meta_value) VALUES (%s, %s)", $meta_key, $meta_value));
        self::$_cache[$meta_key] = $meta_value;
    }

    /**
     * Create mediaspot_zopyron_meta table if it not exists
     */
    public static function updateTable() {
        global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE $wpdb->mediaspot_zopyron_meta (
          id mediumint(9) NOT NULL AUTO_INCREMENT,
          meta_key varchar(255) NOT NULL,
          meta_value longtext DEFAULT '' NOT NULL,
          PRIMARY KEY  (id)
        ) $charset_collate;";

        include_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    }
}
NpMeta::init();